import pandas as pd
import tkinter as tk
from tkinter import filedialog, messagebox, ttk

start_number = 1000  # Numero progressivo iniziale

def load_file():
    global df, file_path
    file_path = filedialog.askopenfilename(
        title="Seleziona il file Excel",
        filetypes=[("Excel Files", "*.xlsx *.xls")]
    )
    
    if not file_path:
        return
    
    try:
        df = pd.read_excel(file_path)
        show_preview(df)
    except Exception as e:
        messagebox.showerror("Errore", f"Impossibile leggere il file.\n{e}")

def show_preview(dataframe):
    preview_tree.delete(*preview_tree.get_children())
    preview_tree["column"] = list(dataframe.columns)
    preview_tree["show"] = "headings"
    
    for col in preview_tree["column"]:
        preview_tree.heading(col, text=col)
    
    for _, row in dataframe.head(10).iterrows():
        preview_tree.insert("", "end", values=list(row))

def process_codes():
    global df
    
    if df is None or "code" not in df.columns:
        messagebox.showwarning("Attenzione", "Nessun file caricato o colonna 'code' mancante.")
        return
    
    unique_codes = df['code'].dropna().unique()
    mapping = {
        code: f"X{start_number + i}Y" for i, code in enumerate(unique_codes)
    }
    
    df['code'] = df['code'].map(mapping)
    df_dict = pd.DataFrame({
        'code_originale': list(mapping.keys()),
        'code_trasformato': list(mapping.values())
    })
    
    output_path = file_path.replace(".xlsx", "_output.xlsx")
    
    try:
        with pd.ExcelWriter(output_path, engine="openpyxl") as writer:
            df.to_excel(writer, sheet_name="Dati", index=False)
            df_dict.to_excel(writer, sheet_name="Dizionario_code", index=False)
        
        messagebox.showinfo("Completato", f"File creato:\n{output_path}")
    except Exception as e:
        messagebox.showerror("Errore", f"Errore durante il salvataggio.\n{e}")

# Interfaccia grafica
root = tk.Tk()
root.title("Trasformazione Codici Excel")

frame = tk.Frame(root)
frame.pack(padx=10, pady=10)

btn_load = tk.Button(frame, text="Scegli File Excel", command=load_file, width=25)
btn_load.grid(row=0, column=0, pady=5)

btn_process = tk.Button(frame, text="Esegui Trasformazione", command=process_codes, width=25)
btn_process.grid(row=1, column=0, pady=5)

preview_tree = ttk.Treeview(root, height=10)
preview_tree.pack(padx=10, pady=10)

df = None
file_path = None

root.mainloop()
